/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.clipboard;

import com.google.common.collect.Lists;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import com.zurrtum.create.infrastructure.packet.c2s.ClipboardEditPacket;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11905;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_474;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_768;
import net.minecraft.class_9323;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClipboardScreen
extends AbstractSimiScreen {
    public ClipboardContent content;
    public class_2338 targetedBlock;
    List<List<ClipboardEntry>> pages;
    List<ClipboardEntry> currentEntries;
    int editingIndex;
    int frameTick;
    class_474 forward;
    class_474 backward;
    int currentPage = 0;
    long lastClickTime;
    int lastIndex = -1;
    int hoveredEntry;
    boolean hoveredCheck;
    boolean readonly;
    DisplayCache displayCache = DisplayCache.EMPTY;
    class_3728 editContext;
    IconButton closeBtn;
    IconButton clearBtn;
    private final int targetSlot;

    public ClipboardScreen(int targetSlot, class_9323 components, @Nullable class_2338 pos) {
        this.targetSlot = targetSlot;
        this.targetedBlock = pos;
        this.reopenWith((ClipboardContent)components.method_58695(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY));
    }

    public void reopenWith(ClipboardContent content) {
        this.content = content;
        this.pages = ClipboardEntry.readAll(content);
        if (this.pages.isEmpty()) {
            this.pages.add(new ArrayList());
        }
        if (this.clearBtn == null) {
            if (content != null) {
                this.currentPage = content.previouslyOpenedPage();
            }
            this.currentPage = class_3532.method_15340((int)this.currentPage, (int)0, (int)(this.pages.size() - 1));
        }
        this.currentEntries = this.pages.get(this.currentPage);
        boolean startEmpty = this.currentEntries.isEmpty();
        if (startEmpty) {
            this.currentEntries.add(new ClipboardEntry(false, class_2561.method_43473()));
        }
        this.editingIndex = 0;
        this.editContext = new class_3728(this::getCurrentEntryText, this::setCurrentEntryText, this::getClipboard, this::setClipboard, this::validateTextForEntry);
        this.editingIndex = startEmpty ? 0 : -1;
        boolean bl = this.readonly = content != null && content.readOnly();
        if (this.readonly) {
            this.editingIndex = -1;
        }
        if (this.clearBtn != null) {
            this.method_25426();
        }
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(256, 256);
        super.method_25426();
        this.clearDisplayCache();
        int x = this.guiLeft;
        int y = this.guiTop - 8;
        this.method_37067();
        this.clearBtn = (IconButton)new IconButton(x + 234, y + 153, AllIcons.I_CLEAR_CHECKED).withCallback(() -> {
            this.editingIndex = -1;
            this.currentEntries.removeIf(ce -> ce.checked);
            if (this.currentEntries.isEmpty()) {
                this.currentEntries.add(new ClipboardEntry(false, class_2561.method_43473()));
            }
            this.sendIfEditingBlock();
        });
        this.clearBtn.setToolTip((class_2561)CreateLang.translateDirect("gui.clipboard.erase_checked", new Object[0]));
        this.closeBtn = (IconButton)new IconButton(x + 234, y + 175, AllIcons.I_PRIORITY_VERY_LOW).withCallback(() -> this.field_22787.method_1507(null));
        this.closeBtn.setToolTip((class_2561)CreateLang.translateDirect("station.close", new Object[0]));
        this.method_37063(this.closeBtn);
        this.method_37063(this.clearBtn);
        this.forward = new class_474(x + 176, y + 229, true, $ -> this.changePage(true), true);
        this.backward = new class_474(x + 53, y + 229, false, $ -> this.changePage(false), true);
        this.method_37063((class_364)this.forward);
        this.method_37063((class_364)this.backward);
        this.forward.field_22764 = this.currentPage < 50 && (!this.readonly || this.currentPage + 1 < this.pages.size());
        this.backward.field_22764 = this.currentPage > 0;
    }

    private int getNumPages() {
        return this.pages.size();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        ++this.frameTick;
        if (this.targetedBlock != null) {
            if (!this.field_22787.field_1724.method_24515().method_19771((class_2382)this.targetedBlock, 10.0)) {
                this.method_25432();
                return;
            }
            if (!this.field_22787.field_1687.method_8320(this.targetedBlock).method_27852((class_2248)AllBlocks.CLIPBOARD)) {
                this.method_25432();
                return;
            }
        }
        class_1041 window = this.field_22787.method_22683();
        int mx = (int)(this.field_22787.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480());
        int my = (int)(this.field_22787.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507());
        this.hoveredCheck = false;
        this.hoveredEntry = -1;
        if ((mx -= this.guiLeft + 35) > 0 && mx < 183 && (my -= this.guiTop + 41) > 0 && my < 190) {
            this.hoveredCheck = mx < 20;
            int totalHeight = 0;
            for (int i = 0; i < this.currentEntries.size(); ++i) {
                ClipboardEntry clipboardEntry = this.currentEntries.get(i);
                String text = clipboardEntry.text.getString();
                if ((totalHeight += Math.max(12, this.field_22793.method_1728((class_5348)class_2561.method_43470((String)text), clipboardEntry.icon.method_7960() ? 150 : 130).size() * 9 + 3)) <= my) continue;
                this.hoveredEntry = i;
                return;
            }
            this.hoveredEntry = this.currentEntries.size();
        }
    }

    private String getCurrentEntryText() {
        return this.currentEntries.get((int)this.editingIndex).text.getString();
    }

    private void setCurrentEntryText(String text) {
        this.currentEntries.get((int)this.editingIndex).text = class_2561.method_43470((String)text);
        this.sendIfEditingBlock();
    }

    private void setClipboard(String p_98148_) {
        if (this.field_22787 != null) {
            class_3728.method_27551((class_310)this.field_22787, (String)p_98148_);
        }
    }

    private String getClipboard() {
        return this.field_22787 != null ? class_3728.method_27556((class_310)this.field_22787) : "";
    }

    private boolean validateTextForEntry(String newText) {
        int totalHeight = 0;
        for (int i = 0; i < this.currentEntries.size(); ++i) {
            ClipboardEntry clipboardEntry = this.currentEntries.get(i);
            String text = i == this.editingIndex ? newText : clipboardEntry.text.getString();
            totalHeight += Math.max(12, this.field_22793.method_1728((class_5348)class_2561.method_43470((String)text), 150).size() * 9 + 3);
        }
        return totalHeight < 185;
    }

    private int yOffsetOfEditingEntry() {
        int totalHeight = 0;
        for (int i = 0; i < this.currentEntries.size() && i != this.editingIndex; ++i) {
            ClipboardEntry clipboardEntry = this.currentEntries.get(i);
            totalHeight += Math.max(12, this.field_22793.method_1728((class_5348)clipboardEntry.text, 150).size() * 9 + 3);
        }
        return totalHeight;
    }

    private void changePage(boolean next) {
        int previously = this.currentPage;
        this.currentPage = class_3532.method_15340((int)(this.currentPage + (next ? 1 : -1)), (int)0, (int)50);
        if (this.currentPage == previously) {
            return;
        }
        this.editingIndex = -1;
        if (this.pages.size() <= this.currentPage) {
            if (this.readonly) {
                this.currentPage = previously;
                return;
            }
            this.pages.add(new ArrayList());
        }
        this.currentEntries = this.pages.get(this.currentPage);
        if (this.currentEntries.isEmpty()) {
            this.currentEntries.add(new ClipboardEntry(false, class_2561.method_43473()));
            if (!this.readonly) {
                this.editingIndex = 0;
                this.editContext.method_16204();
                this.clearDisplayCacheAfterChange();
            }
        }
        this.forward.field_22764 = this.currentPage < 50 && (!this.readonly || this.currentPage + 1 < this.pages.size());
        boolean bl = this.backward.field_22764 = this.currentPage > 0;
        if (next) {
            return;
        }
        if (this.pages.get(this.currentPage + 1).stream().allMatch(ce -> ce.text.getString().isBlank())) {
            this.pages.remove(this.currentPage + 1);
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop - 8;
        AllGuiTextures.CLIPBOARD.render(graphics, x, y);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.getNumPages()}), x + 150, y + 9, 0x43FFFFFF, false);
        for (int i = 0; i < this.currentEntries.size(); ++i) {
            boolean isAddress;
            ClipboardEntry clipboardEntry = this.currentEntries.get(i);
            boolean checked = clipboardEntry.checked;
            int iconOffset = clipboardEntry.icon.method_7960() ? 0 : 16;
            class_5250 text = clipboardEntry.text;
            String string = text.getString();
            boolean bl = isAddress = string.startsWith("#") && !string.substring(1).isBlank();
            if (isAddress) {
                (checked ? AllGuiTextures.CLIPBOARD_ADDRESS_INACTIVE : AllGuiTextures.CLIPBOARD_ADDRESS).render(graphics, x + 44, y + 50);
                text = class_2561.method_43470((String)string.substring(1).stripLeading());
            } else {
                graphics.method_51433(this.field_22793, "\u25a1", x + 45, y + 51, checked ? 1720549227 : -7504021, false);
                if (checked) {
                    graphics.method_51433(this.field_22793, "\u2714", x + 45, y + 50, -13520291, false);
                }
            }
            List split = this.field_22793.method_1728((class_5348)text, 150 - iconOffset);
            if (split.isEmpty()) {
                y += 12;
                continue;
            }
            if (!clipboardEntry.icon.method_7960()) {
                graphics.method_51427(clipboardEntry.icon, x + 54, y + 50);
            }
            for (class_5481 sequence : split) {
                if (i != this.editingIndex) {
                    graphics.method_51430(this.field_22793, sequence, x + 58 + iconOffset, y + 50, checked ? (isAddress ? 1720549227 : -13520291) : -13559296, false);
                }
                y += 9;
            }
            y += 3;
        }
        if (this.editingIndex == -1) {
            return;
        }
        this.method_25395(null);
        DisplayCache cache = this.getDisplayCache();
        for (LineInfo line : cache.lines) {
            graphics.method_51439(this.field_22793, line.asComponent, line.x, line.y, -13559296, false);
        }
        this.renderHighlight(graphics, cache.selection);
        this.renderCursor(graphics, cache.cursor, cache.cursorAtEnd);
    }

    public void method_25432() {
        this.pages.forEach(list -> list.removeIf(ce -> ce.text.getString().isBlank()));
        this.pages.removeIf(List::isEmpty);
        for (int i = 0; i < this.pages.size(); ++i) {
            if (this.pages.get(i) != this.currentEntries) continue;
            this.content = this.content.setPreviouslyOpenedPage(i);
        }
        this.send();
        super.method_25432();
    }

    private void sendIfEditingBlock() {
        class_634 handler = this.field_22787.field_1724.field_3944;
        if (handler.method_2880().size() > 1 && this.targetedBlock != null) {
            this.send();
        }
    }

    private void send() {
        this.content = this.content.setPages(this.pages);
        this.content = this.content.setType(ClipboardType.WRITTEN);
        if (this.pages.isEmpty()) {
            this.content = null;
        }
        this.field_22787.field_1724.field_3944.method_52787((class_2596)new ClipboardEditPacket(this.targetSlot, this.content, this.targetedBlock));
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        this.changePage(pScrollY < 0.0);
        return true;
    }

    @Override
    public boolean method_25404(class_11908 input) {
        int pKeyCode = input.comp_4795();
        if (pKeyCode == 266) {
            this.backward.method_25306((class_11907)input);
            return true;
        }
        if (pKeyCode == 267) {
            this.forward.method_25306((class_11907)input);
            return true;
        }
        if (this.editingIndex != -1 && pKeyCode != 256) {
            this.keyPressedWhileEditing(input);
            this.clearDisplayCache();
            return true;
        }
        super.method_25404(input);
        return true;
    }

    public boolean method_25400(class_11905 input) {
        if (super.method_25400(input)) {
            return true;
        }
        if (!input.method_74227()) {
            return false;
        }
        if (this.editingIndex == -1) {
            return false;
        }
        this.editContext.method_16197(input.method_74226());
        this.clearDisplayCache();
        return true;
    }

    private boolean keyPressedWhileEditing(class_11908 input) {
        if (input.method_74241()) {
            this.editContext.method_27563();
            return true;
        }
        if (input.method_74242()) {
            this.editContext.method_27559();
            return true;
        }
        if (input.method_74243()) {
            this.editContext.method_27554();
            return true;
        }
        if (input.method_74244()) {
            this.editContext.method_27547();
            return true;
        }
        switch (input.comp_4795()) {
            case 257: 
            case 335: {
                if (input.method_74239()) {
                    this.editContext.method_16197("\n");
                    return true;
                }
                if (!input.method_74240()) {
                    if (this.currentEntries.size() <= this.editingIndex + 1 || !this.currentEntries.get((int)(this.editingIndex + 1)).text.getString().isEmpty()) {
                        this.currentEntries.add(this.editingIndex + 1, new ClipboardEntry(false, class_2561.method_43473()));
                    }
                    ++this.editingIndex;
                    this.editContext.method_16204();
                    if (this.validateTextForEntry(" ")) {
                        return true;
                    }
                    this.currentEntries.remove(this.editingIndex);
                    --this.editingIndex;
                    this.editContext.method_16204();
                    return true;
                }
                this.editingIndex = -1;
                return true;
            }
            case 259: {
                if (this.currentEntries.get((int)this.editingIndex).text.getString().isEmpty() && this.currentEntries.size() > 1) {
                    this.currentEntries.remove(this.editingIndex);
                    this.editingIndex = Math.max(0, this.editingIndex - 1);
                    this.editContext.method_16204();
                    return true;
                }
                if (input.method_74240()) {
                    int prevPos = this.editContext.method_16201();
                    this.editContext.method_35728(-1);
                    if (prevPos != this.editContext.method_16201()) {
                        this.editContext.method_27564(prevPos - this.editContext.method_16201());
                    }
                    return true;
                }
                this.editContext.method_27564(-1);
                return true;
            }
            case 261: {
                if (input.method_74240()) {
                    int prevPos = this.editContext.method_16201();
                    this.editContext.method_35728(1);
                    if (prevPos != this.editContext.method_16201()) {
                        this.editContext.method_27564(prevPos - this.editContext.method_16201());
                    }
                    return true;
                }
                this.editContext.method_27564(1);
                return true;
            }
            case 262: {
                if (input.method_74240()) {
                    this.editContext.method_27555(1, input.method_74239());
                    return true;
                }
                this.editContext.method_27549(1, input.method_74239());
                return true;
            }
            case 263: {
                if (input.method_74240()) {
                    this.editContext.method_27555(-1, input.method_74239());
                    return true;
                }
                this.editContext.method_27549(-1, input.method_74239());
                return true;
            }
            case 264: {
                this.keyDown(input);
                return true;
            }
            case 265: {
                this.keyUp(input);
                return true;
            }
            case 268: {
                this.keyHome(input);
                return true;
            }
            case 269: {
                this.keyEnd(input);
                return true;
            }
        }
        return false;
    }

    private void keyUp(class_11908 input) {
        this.changeLine(input, -1);
    }

    private void keyDown(class_11908 input) {
        this.changeLine(input, 1);
    }

    private void changeLine(class_11908 input, int pYChange) {
        int i = this.editContext.method_16201();
        int j = this.getDisplayCache().changeLine(i, pYChange);
        this.editContext.method_27560(j, input.method_74239());
    }

    private void keyHome(class_11908 input) {
        int i = this.editContext.method_16201();
        int j = this.getDisplayCache().findLineStart(i);
        this.editContext.method_27560(j, input.method_74239());
    }

    private void keyEnd(class_11908 input) {
        DisplayCache cache = this.getDisplayCache();
        int i = this.editContext.method_16201();
        int j = cache.findLineEnd(i);
        this.editContext.method_27560(j, input.method_74239());
    }

    private void renderCursor(class_332 graphics, Pos2i pCursorPos, boolean pIsEndOfText) {
        if (this.frameTick / 6 % 2 != 0) {
            return;
        }
        pCursorPos = this.convertLocalToScreen(pCursorPos);
        if (!pIsEndOfText) {
            graphics.method_25294(pCursorPos.x, pCursorPos.y - 1, pCursorPos.x + 1, pCursorPos.y + 9, -16777216);
        } else {
            graphics.method_51433(this.field_22793, "_", pCursorPos.x, pCursorPos.y, -16777216, false);
        }
    }

    private void renderHighlight(class_332 graphics, class_768[] pSelected) {
        for (class_768 rect2i : pSelected) {
            int i = rect2i.method_3321();
            int j = rect2i.method_3322();
            int k = i + rect2i.method_3319();
            int l = j + rect2i.method_3320();
            graphics.method_72238(i, j, k, l, true);
        }
    }

    private Pos2i convertScreenToLocal(Pos2i pScreenPos) {
        return new Pos2i(pScreenPos.x - (this.field_22789 - 192) / 2 - 36 + 10, pScreenPos.y - 32 - 24 - this.yOffsetOfEditingEntry() - this.guiTop + 14);
    }

    private Pos2i convertLocalToScreen(Pos2i pLocalScreenPos) {
        return new Pos2i(pLocalScreenPos.x + (this.field_22789 - 192) / 2 + 36 - 10, pLocalScreenPos.y + 32 + 24 + this.yOffsetOfEditingEntry() + this.guiTop - 14);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (super.method_25402(click, doubled)) {
            return true;
        }
        if (click.method_74245() != 0) {
            return true;
        }
        if (this.hoveredEntry != -1) {
            if (this.hoveredCheck) {
                this.editingIndex = -1;
                if (this.hoveredEntry < this.currentEntries.size()) {
                    this.currentEntries.get((int)this.hoveredEntry).checked ^= true;
                    if (this.currentEntries.get((int)this.hoveredEntry).checked) {
                        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)AllSoundEvents.CLIPBOARD_CHECKMARK.getMainEvent(), (float)(0.95f + (float)Math.random() * 0.05f)));
                    } else {
                        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)AllSoundEvents.CLIPBOARD_ERASE.getMainEvent(), (float)(0.9f + (float)Math.random() * 0.2f)));
                    }
                }
                this.sendIfEditingBlock();
                return true;
            }
            if (this.hoveredEntry != this.editingIndex && !this.readonly) {
                this.editingIndex = this.hoveredEntry;
                if (this.hoveredEntry >= this.currentEntries.size()) {
                    this.currentEntries.add(new ClipboardEntry(false, class_2561.method_43473()));
                    if (!this.validateTextForEntry(" ")) {
                        this.currentEntries.remove(this.hoveredEntry);
                        this.editingIndex = -1;
                        return true;
                    }
                }
                this.clearDisplayCacheAfterChange();
            }
        }
        if (this.editingIndex == -1) {
            return false;
        }
        double pMouseX = click.comp_4798();
        double pMouseY = click.comp_4799();
        if (pMouseX < (double)(this.guiLeft + 50) || pMouseX > (double)(this.guiLeft + 220) || pMouseY < (double)(this.guiTop + 30) || pMouseY > (double)(this.guiTop + 230)) {
            this.method_25395(null);
            this.clearDisplayCache();
            this.editingIndex = -1;
            return false;
        }
        long i = class_156.method_658();
        DisplayCache cache = this.getDisplayCache();
        int j = cache.getIndexAtPosition(this.field_22793, this.convertScreenToLocal(new Pos2i((int)pMouseX, (int)pMouseY)));
        if (j >= 0) {
            if (j == this.lastIndex && i - this.lastClickTime < 250L) {
                if (!this.editContext.method_27568()) {
                    this.selectWord(j);
                } else {
                    this.editContext.method_27563();
                }
            } else {
                this.editContext.method_27560(j, click.method_74239());
            }
            this.clearDisplayCache();
        }
        this.lastIndex = j;
        this.lastClickTime = i;
        return true;
    }

    private void selectWord(int pIndex) {
        String s = this.getCurrentEntryText();
        this.editContext.method_27548(class_5225.method_27483((String)s, (int)-1, (int)pIndex, (boolean)false), class_5225.method_27483((String)s, (int)1, (int)pIndex, (boolean)false));
    }

    public boolean method_25403(class_11909 click, double pDragX, double pDragY) {
        if (super.method_25403(click, pDragX, pDragY)) {
            return true;
        }
        if (click.method_74245() != 0) {
            return true;
        }
        if (this.editingIndex == -1) {
            return false;
        }
        DisplayCache cache = this.getDisplayCache();
        int i = cache.getIndexAtPosition(this.field_22793, this.convertScreenToLocal(new Pos2i((int)click.comp_4798(), (int)click.comp_4799())));
        this.editContext.method_27560(i, true);
        this.clearDisplayCache();
        return true;
    }

    private DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
        }
        return this.displayCache;
    }

    private void clearDisplayCache() {
        this.displayCache = null;
    }

    private void clearDisplayCacheAfterChange() {
        this.editContext.method_16204();
        this.clearDisplayCache();
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i pos;
        boolean flag;
        String current = this.getCurrentEntryText();
        boolean address = current.startsWith("#") && !current.substring(1).isBlank();
        int offset = 0;
        if (address) {
            String stripped = current.substring(1).stripLeading();
            offset = current.length() - stripped.length();
            current = stripped;
        }
        if (current.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        String s = current;
        int i = this.editContext.method_16201();
        int j = this.editContext.method_16203();
        i = class_3532.method_15340((int)(i - offset), (int)0, (int)s.length());
        j = class_3532.method_15340((int)(j - offset), (int)0, (int)s.length());
        IntArrayList intlist = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        class_5225 stringsplitter = this.field_22793.method_27527();
        stringsplitter.method_27485(s, 150, class_2583.field_24360, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$8(mutableint, s, mutableboolean, (IntList)intlist, list, arg_0, arg_1, arg_2));
        int[] aint = intlist.toIntArray();
        boolean bl = flag = i == s.length();
        if (flag && mutableboolean.isTrue()) {
            pos = new Pos2i(0, list.size() * 9);
        } else {
            int k = ClipboardScreen.findLineFromPos(aint, i);
            int l = this.field_22793.method_1727(s.substring(aint[k], i));
            pos = new Pos2i(l, k * 9);
        }
        ArrayList list1 = Lists.newArrayList();
        if (i != j) {
            int k1;
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = ClipboardScreen.findLineFromPos(aint, l2);
            if (j1 == (k1 = ClipboardScreen.findLineFromPos(aint, i1))) {
                int l1 = j1 * 9;
                int i2 = aint[j1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > aint.length ? s.length() : aint[j1 + 1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i3, j1 * 9, aint[j1]));
                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(aint[j3], aint[j3 + 1]);
                    int k2 = (int)stringsplitter.method_27482(s1);
                    list1.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                list1.add(this.createPartialLineSelection(s, stringsplitter, aint[k1], i1, k1 * 9, aint[k1]));
            }
        }
        return new DisplayCache(s, pos, flag, aint, list.toArray(new LineInfo[0]), list1.toArray(new class_768[0]));
    }

    static int findLineFromPos(int[] pLineStarts, int pFind) {
        int i = Arrays.binarySearch(pLineStarts, pFind);
        return i < 0 ? -(i + 2) : i;
    }

    private class_768 createPartialLineSelection(String pInput, class_5225 pSplitter, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s = pInput.substring(p_98125_, p_98122_);
        String s1 = pInput.substring(p_98125_, p_98123_);
        Pos2i firstPos = new Pos2i((int)pSplitter.method_27482(s), p_98124_);
        Pos2i secondPos = new Pos2i((int)pSplitter.method_27482(s1), p_98124_ + 9);
        return this.createSelection(firstPos, secondPos);
    }

    private class_768 createSelection(Pos2i pCorner1, Pos2i pCorner2) {
        Pos2i firstPos = this.convertLocalToScreen(pCorner1);
        Pos2i secondPos = this.convertLocalToScreen(pCorner2);
        int i = Math.min(firstPos.x, secondPos.x);
        int j = Math.max(firstPos.x, secondPos.x);
        int k = Math.min(firstPos.y, secondPos.y);
        int l = Math.max(firstPos.y, secondPos.y);
        return new class_768(i, k, j - i, l - k);
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$8(MutableInt mutableint, String s, MutableBoolean mutableboolean, IntList intlist, List list, class_2583 p_98132_, int p_98133_, int p_98134_) {
        int k3 = mutableint.getAndIncrement();
        String s2 = s.substring(p_98133_, p_98134_);
        mutableboolean.setValue(s2.endsWith("\n"));
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        int l3 = k3 * 9;
        Pos2i pos1 = this.convertLocalToScreen(new Pos2i(0, l3));
        intlist.add(p_98133_);
        list.add(new LineInfo(p_98132_, s3, pos1.x, pos1.y));
    }

    @Environment(value=EnvType.CLIENT)
    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(class_2583.field_24360, "", 0, 0)}, new class_768[0]);
        private final String fullText;
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final class_768[] selection;

        public DisplayCache(String pFullText, Pos2i pCursor, boolean pCursorAtEnd, int[] pLineStarts, LineInfo[] pLines, class_768[] pSelection) {
            this.fullText = pFullText;
            this.cursor = pCursor;
            this.cursorAtEnd = pCursorAtEnd;
            this.lineStarts = pLineStarts;
            this.lines = pLines;
            this.selection = pSelection;
        }

        public int getIndexAtPosition(class_327 pFont, Pos2i pCursorPosition) {
            int i = pCursorPosition.y / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            LineInfo line = this.lines[i];
            return this.lineStarts[i] + pFont.method_27527().method_27484(line.contents, pCursorPosition.x, line.style);
        }

        public int changeLine(int pXChange, int pYChange) {
            int k;
            int i = ClipboardScreen.findLineFromPos(this.lineStarts, pXChange);
            int j = i + pYChange;
            if (0 <= j && j < this.lineStarts.length) {
                int l = pXChange - this.lineStarts[i];
                int i1 = this.lines[j].contents.length();
                k = this.lineStarts[j] + Math.min(l, i1);
            } else {
                k = pXChange;
            }
            return k;
        }

        public int findLineStart(int pLine) {
            int i = ClipboardScreen.findLineFromPos(this.lineStarts, pLine);
            return this.lineStarts[i];
        }

        public int findLineEnd(int pLine) {
            int i = ClipboardScreen.findLineFromPos(this.lineStarts, pLine);
            return this.lineStarts[i] + this.lines[i].contents.length();
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class LineInfo {
        final class_2583 style;
        final String contents;
        final class_2561 asComponent;
        final int x;
        final int y;

        public LineInfo(class_2583 pStyle, String pContents, int pX, int pY) {
            this.style = pStyle;
            this.contents = pContents;
            this.x = pX;
            this.y = pY;
            this.asComponent = class_2561.method_43470((String)pContents).method_10862(pStyle);
        }
    }

    @Environment(value=EnvType.CLIENT)
    record Pos2i(int x, int y) {
    }
}

